<?php
/*--------------------------------------------------------------
   Number.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Option;

use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\OptionTitles;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Option;

class Number implements Option
{
    /**
     * @var Id
     */
    private $id;
    
    /**
     * @var OptionTitles
     */
    private $titles;
    
    /**
     * @var int
     */
    private $value;
    
    /**
     * @var string
     */
    private $type;
    
    
    /**
     * Constructor.
     */
    private function __construct(Id $id, int $value, OptionTitles $titles)
    {
        $this->id     = $id;
        $this->titles = $titles;
        $this->value  = $value;
        $this->type   = "number";
    }
    
    
    /**
     * Create instance.
     */
    public static function create(Id $id, int $value, OptionTitles $titles): self
    {
        return new self($id, $value, $titles);
    }
    
    
    /**
     * @inheritDoc
     */
    public function id(): Id
    {
        return $this->id;
    }
    
    
    /**
     * @inheritDoc
     */
    public function value(): int
    {
        return $this->value;
    }
    
    
    /**
     * @inheritDoc
     */
    public function type(): string
    {
        return $this->type;
    }
    
    
    /**
     * @inheritDoc
     */
    public function titles(): OptionTitles
    {
        return $this->titles;
    }
}